/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.StringDialog;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.MouseMapper;

public class ColibriCreateSubdesignCommand
extends Command
implements ActionListener {
    Point newPos;
    Point oldPos;
    SimObject target;
    ObjectCanvas canvas;
    StringDialog stringDialog;
    String designName;

    public ColibriCreateSubdesignCommand(Editor editor, String _designName) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.designName = _designName;
        try {
            DesignManager manager = DesignManager.getDesignManager();
            if (this.designName == null) {
                this.designName = manager.selectFileOrURLName("Select design... (*.hds)", "new.hds", ".hds", 0);
                if (this.designName == null) {
                    this.ready = true;
                    return;
                }
            }
            this.target = manager.getDesign(editor, this.designName, false);
            Symbol tmp = SymbolManager.getSymbolManager().getSymbol(this.target);
            this.target.setSymbol(tmp);
            this.target.getSymbol().setTrafo(this.canvas.getTrafo());
            this.target.getSymbol().move(0, 0);
            this.statusMessage("click where to put the subdesign");
        }
        catch (Exception e) {
            this.message("-E- Couldn't load subdesign: " + this.designName);
            this.message("-E- Exception is: " + e);
            this.ready = true;
            return;
        }
        this.ready = false;
        this.oldPos = null;
        this.newPos = null;
        this.setPosition(new Point(0, 0), new Point(0, 0));
    }

    public void execute() {
        Design design = (Design)this.target;
        if (design == null) {
            this.message("-E- Internal error in CreateSubDesignCommand: design is null");
            this.target = null;
            return;
        }
        Symbol symbol = design.getSymbol();
        if (symbol == null) {
            this.message("-E- Internal error in CreateSubDesignCommand: design has no valid symbol: " + design);
            return;
        }
        this.editor.getDesign().addComponent(design);
        symbol.setTrafo(this.canvas.getTrafo());
        symbol.move(this.newPos.x, this.newPos.y);
        this.editor.insertIntoObjectList(symbol);
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
        this.editor.setCommand(new ColibriCreateSubdesignCommand(this.editor, this.designName));
    }

    public void undo() {
        if (this.target != null) {
            this.target.getSymbol().move(-this.newPos.x, -this.newPos.y);
            this.editor.getDesign().deleteComponent(this.target);
            this.editor.rebuildObjectList(this.editor.getDesign());
            this.canvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent ME) {
        if (MouseMapper.isMiddleClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else if (MouseMapper.isRightClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else {
            Point WP = ME.getWorldCoordinatePoint();
            Point SP = ME.getScreenCoordinatePoint();
            this.setPosition(SP, WP);
        }
    }

    public void setPosition(Point SP, Point WP) {
        if (this.oldPos == null) {
            this.oldPos = new Point(WP);
            this.canvas.setEnablePopup(false);
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(5, this.canvas.getTrafo(), this.target.getSymbol().getBbox());
            this.canvas.doFullRedraw();
            this.statusMessage("Left button: position object, middle/right: cancel");
        } else {
            this.newPos = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("ready... select a command");
            this.execute();
            this.ready = true;
        }
    }

    public String toString() {
        return "ColibriCreateSubdesignCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "create instance";
    }

    static {
        Command.versionString = "HADES ColibriCreateSubdesignCommand 0.4 (03.04.98)";
    }
}

