/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.StringDialog;
import hades.signals.Signal;
import hades.simulator.SimObject;
import hades.symbols.WireSegment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jfig.objects.FigObject;

public class ChangeSignalNameCommand
extends Command
implements ActionListener {
    Point newPos;
    Signal target;
    ObjectCanvas canvas;
    StringDialog stringDialog;
    boolean hasName;
    String newname;
    String oldname;

    public ChangeSignalNameCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.hasName = false;
        this.newname = null;
        this.oldname = null;
        this.ready = false;
        this.newPos = null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (Command.debug) {
            this.message("-W- CNC: actionPerformed: " + evt);
        }
        if (evt.getActionCommand().equals("Cancel")) {
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.ready = true;
            return;
        }
        if (evt.getActionCommand().equals("OK") || evt.getSource() == this.stringDialog.getTextComponent()) {
            if (Command.debug) {
                this.message("-W- CNC: actionPerformed[OK/TF]: " + evt);
            }
            this.newname = this.stringDialog.getText();
            if (this.newname.indexOf(32) > 0 || this.newname.indexOf(9) > 0) {
                this.newname = this.newname.replace(' ', '_');
                this.newname = this.newname.replace('\t', '_');
                this.message("-W- name contains spaces/tabs, changed to: " + this.newname);
            }
            this.stringDialog.getDialog().setVisible(false);
            this.stringDialog.getDialog().dispose();
            this.editor.getFrame().requestFocus();
            this.execute();
            this.ready = true;
        } else {
            this.message("-E- internal: unknown event source in ChangeSignalNameCommand: " + evt);
        }
    }

    public void execute() {
        if (this.target instanceof Signal) {
            if (Command.debug) {
                this.message("-I- ChangeSignalNameCommand for " + this.target + " new='" + this.newname + "', old='" + this.oldname + "'");
            }
            this.target.setName(this.newname);
        }
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.target.setName(this.oldname);
        this.canvas.doFullRedraw();
    }

    public void setPosition(Point SP, Point WP) {
        this.newPos = new Point(WP);
        FigObject tmp = this.editor.findSymbolOrSignal(WP);
        if (tmp instanceof WireSegment) {
            this.target = ((WireSegment)tmp).getSignal();
        } else if (tmp instanceof SimObject) {
            if (this.editor.isOnPort(WP)) {
                this.target = this.editor.findPort(WP).getSignal();
            }
        } else if (tmp == null && (tmp = this.editor.findNearestWireSegment(WP)) != null && tmp instanceof WireSegment) {
            this.target = ((WireSegment)tmp).getSignal();
        }
        if (this.target == null) {
            this.message("-E- no Signal found at/near that position!");
            this.ready = true;
            return;
        }
        this.stringDialog = StringDialog.createStringDialog(this.editor.getFrame(), "Enter the signal's name:", "");
        this.stringDialog.addActionListener(this);
        this.oldname = this.target.getName();
        this.stringDialog.setText(this.oldname);
        Point Q = this.canvas.getComponent().getLocationOnScreen();
        Point P = new Point(Q.x + SP.x + 20, Q.y + SP.y - 40);
        this.stringDialog.getDialog().setLocation(P);
        this.stringDialog.getDialog().setVisible(true);
        this.stringDialog.getDialog().requestFocus();
        this.stringDialog.selectText(true);
    }

    public String toString() {
        return "ChangeSignalNameCommand at pos: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "change signal name";
    }

    static {
        Command.versionString = "HADES ChangeSignalNameCommand 0.1 (22.07.97)";
    }
}

