/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ImageCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jfig.gui.ImageHelper;
import jfig.gui.InsetsPanel;

public class AboutDialog
extends Dialog
implements ActionListener {
    private Panel labelPanel;
    private Panel imagePanel;
    private Panel buttonPanel;
    private Button OK;
    private Label text0;
    private Label text1;
    private Label text2;
    private Label text3;
    private Image image;
    private ImageCanvas imageCanvas;
    private Color backgroundColor = Color.lightGray;

    public AboutDialog(Frame parent, String versionString) {
        super(parent, "About Hades", false);
        this.setBackground(this.backgroundColor);
        this.addWindowListener(new EditWindowListener());
        this.buildLabelPanel(versionString);
        this.buildImagePanel();
        this.buildButtonPanel();
        InsetsPanel panel = new InsetsPanel(20, 30, 20, 10);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.setBackground(this.backgroundColor);
        panel.add("West", (Component)this.imageCanvas);
        panel.add("Center", (Component)this.labelPanel);
        panel.add("South", (Component)this.buttonPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)panel);
        this.pack();
    }

    void buildImagePanel() {
        this.imagePanel = new Panel();
        this.imagePanel.setBackground(this.backgroundColor);
        this.imagePanel.setLayout(new FlowLayout(1));
        this.image = ImageHelper.loadResourceImage("/hades/gui/images/hades.gif");
        this.imageCanvas = new ImageCanvas(this.image);
        this.imageCanvas.setBackground(this.backgroundColor);
    }

    void buildLabelPanel(String versionString) {
        this.labelPanel = new Panel();
        this.labelPanel.setBackground(this.backgroundColor);
        this.labelPanel.setLayout(new GridLayout(5, 1));
        this.text0 = new Label(versionString);
        this.text1 = new Label("A Java-based simulation framework");
        this.text2 = new Label("(C) 1997-2004 by Norman Hendrich");
        this.text3 = new Label("hendrich@informatik.uni-hamburg.de");
        this.text0.setAlignment(1);
        this.text1.setAlignment(1);
        this.text2.setAlignment(1);
        this.text3.setAlignment(1);
        this.labelPanel.add(this.text0);
        this.labelPanel.add(this.text1);
        this.labelPanel.add(new Label(""));
        this.labelPanel.add(this.text2);
        this.labelPanel.add(this.text3);
    }

    void buildButtonPanel() {
        this.OK = new Button("OK");
        this.OK.addActionListener(this);
        this.buttonPanel = new Panel();
        this.buttonPanel.setBackground(this.backgroundColor);
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.buttonPanel.add(this.OK);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.OK) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] argv) {
        Frame frame = new Frame("AboutDialog selftest");
        frame.setVisible(true);
        AboutDialog ad = new AboutDialog(frame, "Hades 0.01");
        ad.setVisible(true);
        ad.pack();
    }

    class EditWindowListener
    extends WindowAdapter {
        EditWindowListener() {
        }

        public void windowClosing(WindowEvent event) {
            AboutDialog.this.dispose();
        }
    }
}

