/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.PropertySheet;
import hades.gui.WindowCloser;
import hades.models.io.ClockGen;
import hades.simulator.SimObject;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jfig.gui.InsetsPanel;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AWTPropertySheet
extends PropertySheet
implements ActionListener {
    static String[] dummy = new String[]{"instance name", "name", "preset time:", "t1", "active time:", "t2", "passive time:", "t3"};
    private SimObject simObject;
    private String[] fields;
    private Dialog dialog;
    private TextArea helpTextArea;
    private InsetsPanel topPanel;
    private InsetsPanel centerPanel;
    private InsetsPanel labelPanel;
    private InsetsPanel tfPanel;
    private InsetsPanel buttonPanel;
    private Button okButton;
    private Button applyButton;
    private Button cancelButton;
    private Button updateButton;
    private Color backgroundColor;
    private String[] variableNames;
    private Label[] labels;
    private TextField[] textFields;
    private Method[] getters;
    private Method[] setters;
    static /* synthetic */ Class class$java$lang$String;

    public void pack() {
        this.dialog.pack();
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }

    public void buildTopPanel() {
        this.helpTextArea = new TextArea(5, 30);
        this.helpTextArea.setFont(new Font("Monospaced", 0, 12));
        this.helpTextArea.setBackground(this.backgroundColor);
        this.helpTextArea.setText("Specify instance properties:");
        this.helpTextArea.setEditable(false);
        this.topPanel = new InsetsPanel(0, 0);
        this.topPanel.setLayout((LayoutManager)new BorderLayout());
        this.topPanel.setBackground(this.backgroundColor);
        if (System.getProperty("java.vendor").indexOf("IBM") >= 0) {
            TextField ibmTF = new TextField("Edit instance properties");
            ibmTF.setEditable(false);
            this.topPanel.add("Center", (Component)ibmTF);
        } else {
            this.topPanel.add("Center", (Component)this.helpTextArea);
        }
    }

    public void setHelpText(String msg) {
        this.helpTextArea.setText(msg);
        if (msg == "") {
            this.helpTextArea.setVisible(false);
        } else {
            this.helpTextArea.setVisible(true);
        }
        this.dialog.invalidate();
        this.dialog.pack();
    }

    public void buildButtonPanel() {
        this.okButton = new Button("OK");
        this.applyButton = new Button("Apply");
        this.cancelButton = new Button("Cancel");
        this.updateButton = new Button("Reload");
        this.updateButton.setVisible(false);
        this.buttonPanel = new InsetsPanel(0, 0);
        this.buttonPanel.setBackground(this.backgroundColor);
        this.buttonPanel.setLayout((LayoutManager)new FlowLayout(1));
        this.buttonPanel.add((Component)this.cancelButton);
        this.buttonPanel.add((Component)new Label(""));
        this.buttonPanel.add((Component)this.updateButton);
        this.buttonPanel.add((Component)this.applyButton);
        this.buttonPanel.add((Component)this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.updateButton.addActionListener(this);
    }

    public void enableUpdateButton(boolean enable) {
        this.updateButton.setVisible(enable);
    }

    public void buildCenterPanel() {
        int n_rows = 0;
        if (this.fields == null) {
            n_rows = 1;
            this.fields = new String[2];
            this.fields[0] = "instance name:";
            this.fields[1] = "name";
        } else {
            n_rows = this.fields.length / 2;
        }
        if (debug) {
            System.out.println("PE: n_rows = " + n_rows);
        }
        this.variableNames = new String[n_rows];
        this.labels = new Label[n_rows];
        this.textFields = new TextField[n_rows];
        this.getters = new Method[n_rows];
        this.setters = new Method[n_rows];
        this.labelPanel = new InsetsPanel(5, 5);
        this.labelPanel.setBackground(this.backgroundColor);
        this.labelPanel.setLayout((LayoutManager)new GridLayout(n_rows, 1, 2, 2));
        this.tfPanel = new InsetsPanel(5, 5);
        this.tfPanel.setBackground(this.backgroundColor);
        this.tfPanel.setLayout((LayoutManager)new GridLayout(n_rows, 1, 2, 2));
        this.centerPanel = new InsetsPanel(5, 5);
        this.centerPanel.setLowered();
        this.centerPanel.setBackground(this.backgroundColor);
        this.centerPanel.setLayout((LayoutManager)new BorderLayout());
        this.centerPanel.add("West", (Component)this.labelPanel);
        this.centerPanel.add("Center", (Component)this.tfPanel);
        int i = 0;
        while (i < this.variableNames.length) {
            this.addRow(i, this.fields[2 * i], this.fields[2 * i + 1]);
            ++i;
        }
    }

    public void addRow(int i, String label, String fieldname) {
        if (debug) {
            System.out.println("PE.addRow(" + i + ' ' + label + ',' + fieldname + ')');
        }
        try {
            this.variableNames[i] = fieldname;
            Object[] noArgs = new Class[]{};
            this.getters[i] = this.simObject.getClass().getMethod("get" + this.capitalize(fieldname), (Class<?>[])noArgs);
            Class[] oneStringArg = new Class[1];
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = AWTPropertySheet.class("[Ljava.lang.String;", false);
            }
            oneStringArg[0] = clazz;
            this.setters[i] = this.simObject.getClass().getMethod("set" + this.capitalize(fieldname), oneStringArg);
            String value = "" + this.getters[i].invoke((Object)this.simObject, noArgs);
            if (debug) {
                System.out.println("PE.addRow(" + this.getters[i] + ' ' + this.setters[i] + " value is " + value);
            }
            this.labels[i] = new Label(label, 2);
            this.textFields[i] = new TextField(value, 12);
            this.labels[i].setBackground(this.backgroundColor);
            this.textFields[i].setBackground(this.backgroundColor);
            this.labelPanel.add((Component)this.labels[i]);
            this.tfPanel.add((Component)this.textFields[i]);
        }
        catch (InvocationTargetException ite) {
            Throwable original = ite.getTargetException();
            if (debug) {
                AWTPropertySheet.msg("-E- AWTPropertySheet.applyValues: " + original);
            }
            ExceptionTracer.trace(original);
        }
        catch (Exception e) {
            if (debug) {
                AWTPropertySheet.msg("-E- AWTPropertySheet.addRow(): " + e);
            }
            ExceptionTracer.trace(e);
        }
    }

    public void applyValues() {
        int i = 0;
        while (i < this.variableNames.length) {
            try {
                String tmp = this.textFields[i].getText();
                Object[] args = new String[]{tmp};
                this.setters[i].invoke((Object)this.simObject, args);
            }
            catch (InvocationTargetException ite) {
                Throwable original = ite.getTargetException();
                AWTPropertySheet.msg("-E- AWTPropertySheet.applyValues: " + original);
                ExceptionTracer.trace(original);
            }
            catch (Exception e) {
                AWTPropertySheet.msg("-E- AWTPropertySheet.applyValues(): caught " + e);
                ExceptionTracer.trace(e);
            }
            ++i;
        }
        try {
            this.simObject.getEditor().doFullRedraw();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateValues() {
        int i = 0;
        while (i < this.getters.length) {
            Object[] noArgs = new Class[]{};
            try {
                this.textFields[i].setText("" + this.getters[i].invoke((Object)this.simObject, noArgs));
            }
            catch (InvocationTargetException ite) {
                Throwable original = ite.getTargetException();
                AWTPropertySheet.msg("-E- AWTPropertySheet.updateValues: " + original);
                ExceptionTracer.trace(original);
            }
            catch (Exception e) {
                AWTPropertySheet.msg("-E- AWTPropertySheet.updateValues(): " + e);
                ExceptionTracer.trace(e);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source;
        if (debug) {
            System.out.println("PE.actionPerformed(): " + evt);
        }
        if ((source = evt.getSource()) == this.cancelButton) {
            this.hideWindow();
        } else if (source == this.applyButton) {
            this.applyValues();
        } else if (source == this.okButton) {
            this.applyValues();
            this.hideWindow();
        } else if (source == this.updateButton) {
            this.updateValues();
        } else if (source instanceof TextField) {
            this.applyValues();
        } else {
            System.out.println("PE: unknown event source for: " + evt);
        }
    }

    public void dispose() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void tearDown() {
        this.simObject = null;
        this.fields = null;
        this.helpTextArea = null;
        this.topPanel = null;
        this.centerPanel = null;
        this.labelPanel = null;
        this.tfPanel = null;
        this.buttonPanel = null;
        this.okButton = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.updateButton = null;
        this.variableNames = null;
        this.labels = null;
        this.textFields = null;
        this.getters = null;
        this.setters = null;
        this.dispose();
        this.dialog = null;
    }

    public void hideWindow() {
        this.setVisible(false);
        try {
            this.simObject.getEditor().doFullRedraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _objectTable.remove(this.simObject);
    }

    public String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        if (s.length() > 1) {
            return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
        }
        return "we never arrive here, but the Java compiler sucks";
    }

    public static void main(String[] argv) {
        System.out.println("AWTPropertySheet main(): self test started...");
        Frame frame = new Frame("AWTPropertySheet test");
        frame.setSize(new Dimension(100, 100));
        frame.setVisible(true);
        String[] fields = new String[]{"name:", "name", "period [sec]:", "period", "frac. [0..1]:", "dutycycle", "offset [sec]:", "offset"};
        PropertySheet ps = AWTPropertySheet.getPropertySheet(new ClockGen(), frame, fields);
        ps.setHelpText("ClockGenerator timing parameters:   \n_____11111__________11111_______ ...\n0         1              2          \n| t0 | t1 | t0 | t1 | ...           \n");
        ps.enableUpdateButton(true);
        ps.pack();
        ps.setVisible(true);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public AWTPropertySheet(SimObject obj, Frame frame, String[] _fields) {
        this.dialog = new Dialog(frame, this.buildTitle(obj), false);
        this.simObject = obj;
        this.fields = _fields;
        this.backgroundColor = SetupManager.getColor("Hades.PropertySheet.backgroundColor", new Color(220, 220, 220));
        this.dialog.setBackground(this.backgroundColor);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setSize(200, 200);
        if (debug) {
            System.out.println("AWTPropertySheet<init> #1");
        }
        this.buildTopPanel();
        this.buildCenterPanel();
        this.buildButtonPanel();
        if (debug) {
            System.out.println("AWTPropertySheet<init> #2");
        }
        this.dialog.add("North", (Component)this.topPanel);
        this.dialog.add("Center", (Component)this.centerPanel);
        this.dialog.add("South", (Component)this.buttonPanel);
        this.dialog.pack();
        if (debug) {
            System.out.println("AWTPropertySheet<init> #3");
        }
        this.dialog.addWindowListener(new WindowCloser(this.dialog));
    }
}

