/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.AWTObjectCanvas;
import hades.gui.AWTPropertySheet;
import hades.gui.AWTSelectURLDialog;
import hades.gui.AWTSimControlPanel;
import hades.gui.AWTStatusPanel;
import hades.gui.AWTStringDialog;
import hades.gui.AboutDialog;
import hades.gui.CanvasScroller;
import hades.gui.EditFrame;
import hades.gui.Editor;
import hades.gui.ExportOptionsDialog;
import hades.gui.GUIFactory;
import hades.gui.ObjectCanvas;
import hades.gui.PropertiesViewer;
import hades.gui.PropertySheet;
import hades.gui.SelectURLDialog;
import hades.gui.SimControlPanel;
import hades.gui.StatusPanel;
import hades.gui.StringDialog;
import hades.manager.DesignManager;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.InputStream;
import jfig.gui.SimpleTextViewer;
import jfig.utils.SetupManager;

class AWTFactory
extends GUIFactory {
    AWTFactory() {
    }

    public Frame createEditFrame(Editor editor, String versionString) {
        return new EditFrame(editor, versionString);
    }

    public ObjectCanvas createObjectCanvas(Editor editor) {
        return new AWTObjectCanvas(editor);
    }

    public StatusPanel createStatusPanel() {
        return new AWTStatusPanel();
    }

    public SimControlPanel createSimControlPanel(SimKernel s, Frame f) {
        return new AWTSimControlPanel(s, f);
    }

    public Container createEditFrameLayout(Frame editFrame, Component statusPanel, ObjectCanvas objectCanvas) {
        Frame container = editFrame;
        container.add("North", statusPanel);
        container.add("Center", new CanvasScroller(objectCanvas));
        return container;
    }

    public void doShowProperties() {
        PropertiesViewer pv = new PropertiesViewer(SetupManager.getProperties());
        pv.setTitle("Hades properties");
        pv.showProperties();
        pv.setVisible(true);
    }

    public Component createAndShowTextViewer(String title, int rows, int cols, String resource) {
        try {
            InputStream inputStream = DesignManager.getDesignManager().getInputStream(this, resource);
            SimpleTextViewer viewer = new SimpleTextViewer(title, rows, cols);
            viewer.parse(inputStream);
            viewer.setVisible(true);
            inputStream.close();
            return viewer;
        }
        catch (Throwable t) {
            System.err.println("-E- Editor.createAndShowTextViewer failed: " + t);
            return null;
        }
    }

    public void doShowAbout(Frame frame, String versionString) {
        AboutDialog about = new AboutDialog(frame, versionString);
        about.setSize(300, 300);
        about.setBackground(Color.white);
        about.pack();
        about.setVisible(true);
    }

    public StringDialog createStringDialog(Frame frame, String title, String prompt) {
        return new AWTStringDialog(frame, title, prompt);
    }

    public SelectURLDialog createSelectURLDialog(Frame frame, String title, String defaultUrlName) {
        return new AWTSelectURLDialog(frame, title, defaultUrlName);
    }

    public PropertySheet getPropertySheet(SimObject simObj, Frame frame, String[] fields) {
        return new AWTPropertySheet(simObj, frame, fields);
    }

    public ExportOptionsDialog createExportOptionsDialog(Editor editor) {
        return null;
    }
}

